# ironic.sh - Devstack extras script to install ironic

# NOTE(jroll) this is used for the transition to a devstack plugin in
# the ironic tree.
IRONIC_USING_PLUGIN=$(trueorfalse False IRONIC_USING_PLUGIN)
if [[ "$IRONIC_USING_PLUGIN" == "True" ]] ; then
    return 0
fi

if is_service_enabled ir-api ir-cond; then
    if [[ "$1" == "source" ]]; then
        # Initial source
        source $TOP_DIR/lib/ironic
    elif [[ "$1" == "stack" && "$2" == "install" ]]; then
        echo_summary "Installing Ironic"
        install_ironic
        install_ironicclient
        cleanup_ironic
    elif [[ "$1" == "stack" && "$2" == "post-config" ]]; then
        echo_summary "Configuring Ironic"
        configure_ironic

        if is_service_enabled key; then
            create_ironic_accounts
        fi

    elif [[ "$1" == "stack" && "$2" == "extra" ]]; then
        # Initialize ironic
        init_ironic

        # Start the ironic API and ironic taskmgr components
        echo_summary "Starting Ironic"
        start_ironic

        if [[ "$IRONIC_BAREMETAL_BASIC_OPS" = "True" ]]; then
            prepare_baremetal_basic_ops
        fi
    fi

    if [[ "$1" == "unstack" ]]; then
        stop_ironic
        if [[ "$IRONIC_BAREMETAL_BASIC_OPS" = "True" ]]; then
            cleanup_baremetal_basic_ops
        fi
    fi

    if [[ "$1" == "clean" ]]; then
        cleanup_ironic
    fi
fi
