# SPDX-FileCopyrightText: StorPool <support@storpool.com>
# SPDX-License-Identifier: BSD-2-Clause

{ pkgs ? import <nixpkgs> {}, perl-ver ? 536 }:
let
  perl-tree-name = "perl${toString perl-ver}Packages";
  perl-tree = builtins.getAttr perl-tree-name pkgs;
  perl-pkgs = with perl-tree; [ perl PathTiny ];
in pkgs.mkShell {
  buildInputs = [
    pkgs.git
    perl-pkgs
  ];
  shellHook = ''
    set -e
    perl tests/gifn-test.pl sh/git-if-needed
    exit
  '';
}
