# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: BSD-2-Clause
"""Run git-if-needed."""

from __future__ import annotations

import shlex
import subprocess

from typing import TYPE_CHECKING

from . import defs

if TYPE_CHECKING:
    import pathlib


def apply_series(cfg: defs.Config, tempd: pathlib.Path) -> None:
    """Run git-if-needed to apply all the patches in a series file."""
    cmd: list[str | pathlib.Path] = [cfg.program, "-s", cfg.series, "--", "am"]
    cmdstr = shlex.join(str(arg) for arg in cmd)
    cfg.log.debug("Running `%(cmdstr)s`", {"cmdstr": cmdstr})
    try:
        subprocess.run(cmd, check=True, cwd=tempd, shell=False)
    except (OSError, subprocess.CalledProcessError) as err:
        raise defs.GApplyError(f"Could not run `{cmdstr}` in {tempd}: {err}") from err
