# SPDX-FileCopyrightText: StorPool <support@storpool.com>
# SPDX-License-Identifier: BSD-2-Clause
"""Common definitions for the gifn-apply routines."""

from __future__ import annotations

import dataclasses
import typing


if typing.TYPE_CHECKING:
    import logging
    import pathlib
    import urllib.parse as uparse


VERSION = "0.1.0"


class GApplyError(Exception):
    """The base class for errors that occurred during the gifn-apply operation."""


@dataclasses.dataclass(frozen=True, order=True)
class Repo:
    """A repository split into the origin fragment and the name/path within."""

    origin: str
    repo: str

    @property
    def path(self) -> str:
        """Combine the origin and the repo path."""
        return f"{self.origin}/{self.repo}"


@dataclasses.dataclass(frozen=True)
class RepoURL:
    """A parsed URL for a repo base."""

    url: uparse.ParseResult


@dataclasses.dataclass(frozen=True)
class Config:
    """Runtime configuration for the gifn-apply tool."""

    log: logging.Logger
    program: pathlib.Path
    patches: pathlib.Path
    series: pathlib.Path
    repo_urls: dict[str, RepoURL]
