# SPDX-FileCopyrightText: StorPool <support@storpool.com>
# SPDX-License-Identifier: BSD-2-Clause
"""Test the gifn_apply.util functions."""

import pytest

from gifn_apply import util


@pytest.mark.parametrize(
    ("value", "prefix", "expected"),
    [
        ("hello", "goodbye", "hello"),
        ("hello", "hel", "lo"),
        ("hel", "hello", "hel"),
        ("hello", "hello", ""),
    ],
)
def test_remove_prefix(value: str, prefix: str, expected: str) -> None:
    """Test our hand-rolled str.removeprefix() implementation."""
    assert util.str_removeprefix(value, prefix) == expected
